'use strict';

function BCPJobsModalCtrl($scope, $rootScope, RandomEmployeesList, DepartmentsList){
    var elementId = "#modal-jobs";
    $scope.currentDepartment = {};
    $scope.checkedAll = false;
    $scope.search = {};
    $scope.predicate = '';
    $scope.employeesFilterTypes = RandomEmployeesList.filterTypes;

    $scope.$on('Jobs:openWindow', function(event, department){
        $scope.currentDepartment = department;
        $scope.employees = angular.copy(RandomEmployeesList.loadData());
        $scope.openModal();
    });

    $scope.openModal = function(){
        angular.element(elementId).modal('show');
        setTimeout(function(){
            $(".nano").nanoScroller({alwaysVisible: true});
        }, 300);
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }

    $scope.filterEmployees = function(employee){
        var valid = true;

        if(typeof $scope.search.salaryMin != 'undefined' && $scope.search.salaryMin != ''){
            valid = (employee.salary >= $scope.search.salaryMin);
            if(!valid) {return valid;}
        }
        if(typeof $scope.search.salaryMax != 'undefined' && $scope.search.salaryMax != '')
        {
            valid = (employee.salary <= $scope.search.salaryMax);
            if(!valid) {return valid;}
        }
        if(typeof $scope.search.seniorityMin != 'undefined' && $scope.search.seniorityMin != ''){
            valid = ((employee.seniority) >= $scope.search.seniorityMin);
            if(!valid) {return valid;}
        }
        if(typeof $scope.search.seniorityMax != 'undefined' && $scope.search.seniorityMax != ''){
            valid = ((employee.seniority) <= $scope.search.seniorityMax);
            if(!valid) {return valid;}
        }
        if(typeof $scope.search.education != 'undefined' && $scope.search.education != ''){
            valid = (employee.education == $scope.search.education);
            if(!valid) {return valid;}
        }
        if(typeof $scope.search.studies != 'undefined' && $scope.search.studies != ''){
            valid = (employee.studies == $scope.search.studies);
            if(!valid) {return valid;}
        }
        if(typeof $scope.search.driver != 'undefined' && $scope.search.driver != '')
        {
            var cats = angular.copy($scope.search.driver.toLowerCase());
            cats = cats.replace(/[^a-z]/g, '').split('');

            for(var i = 0; i < cats.length; i++)
            {
                if(employee.driver.toLowerCase().indexOf(cats[i]) === -1)
                {
                    valid = false;
                    break;
                }
            };

            if(!valid) {return valid;}
        }

        return valid;
    }

    $scope.reloadList = function(){
        var message = {
            title: 'Oferty pracy'
            ,msg: 'Szukam nowych ofert pracy. Proszę czekać'
        }
        $rootScope.$broadcast('Message:addMsg', message);
        $scope.closeModal();
        RandomEmployeesList.reload(function(){
            $scope.employees = angular.copy(RandomEmployeesList.loadData());

            $rootScope.$broadcast('Message:delMsg', message);
            setTimeout(function(){
                $scope.employeesFilterTypes = RandomEmployeesList.filterTypes;
                $scope.openModal();
            }, 300);
        });
    }

    $scope.hireEmployees = function(){
        $scope.employees.forEach(function(Employee){
            if(Employee.isChecked())
            {
                $scope.currentDepartment.hireEmployee(Employee);
            }
        });

        $scope.closeModal();
    }

    $scope.isAnySelected = function(){
        var isSelected = false;
        for(var i = 0; i < $scope.employees.length; i++)
        {
            if($scope.employees[i].isChecked())
            {
                isSelected = true;
                break;
            }
        }
        return isSelected;
    }


    $scope.isCompanyEmployee = function(Employee){
        return DepartmentsList.isCompanyEmployee(Employee);
    }
}

BCPJobsModalCtrl.$inject = ['$scope', '$rootScope', 'RandomEmployeesList', 'DepartmentsList'];
